<?php

// Fetch the HTML content using cURL
$url = 'https://www.versagroup.be/en/All-Products/';
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36');
$html = curl_exec($ch);
curl_close($ch);

// Debug: Ensure HTML is fetched
if (!$html) {
    die("Failed to fetch HTML content.");
}

// Load the HTML into DOMDocument
$dom = new DOMDocument();
libxml_use_internal_errors(true); // Suppress warnings for malformed HTML
$dom->loadHTML($html);
libxml_clear_errors();

// Initialize DOMXPath
$xpath = new DOMXPath($dom);

// Query elements with class 'cms-teaser-image' and 'cms-teaser-image-link'
$imageElements = $xpath->query("//img[contains(@class, 'cms-teaser-image')]");
$linkElements = $xpath->query("//a[contains(@class, 'cms-teaser-image-link')]");

// Debug: Check the number of elements found
echo "Images found: " . $imageElements->length . "\n";
echo "Links found: " . $linkElements->length . "\n";

// Initialize the result array
$data = [];

// Loop through 'cms-teaser-image' elements and add 'src' to the array
foreach ($imageElements as $key => $image) {
    $data[$key]['src'] = $image->getAttribute('src');
}

// Loop through 'cms-teaser-image-link' elements and add 'href' and 'title' to the array
foreach ($linkElements as $key => $link) {
    $data[$key]['href'] = $link->getAttribute('href');
    $data[$key]['title'] = $link->getAttribute('title');
}

// Debug: Print the result array
echo "<pre>";print_r($data);


